﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Pay_and_Bonus
{
    public partial class Form1 : Form
    {
        // Stała określająca procentową wysokość kwoty przekazywanej na konto emerytalne.
        private const decimal CONTRIB_RATE = 0.05m;

        public Form1()
        {
            InitializeComponent();
        }

        // Metoda InputIsValid() konwertuje dane wejściowe użytkownika
        // i przechowuje je w argumentach (przekazanych przez referencję).
        // Jeżeli konwersja zakończy się sukcesem, metoda zwróci wartość true.
        // W przeciwnym razie wartością zwrotną jest false. 
        private bool InputIsValid(ref decimal pay, ref decimal bonus)
        { 
            // Zmienna wskazująca poprawność danych wejściowych.
            bool inputGood = false; 

            // Próba konwersji danych wejściowych na wartości typu decimal. 
            if (decimal.TryParse(grossPayTextBox.Text, out pay)) 
            { 
                if (decimal.TryParse(bonusTextBox.Text, out bonus))
                { 
                    // Wszystkie dane wejściowe są poprawne.
                    inputGood = true; 
                } 
                else 
                { 
                    // Wyświetlenie komunikatu błędu dotyczącego premii.
                    MessageBox.Show("Nieprawidłowa wielkość premii."); 
                } 
            } 
            else 
            { 
                // Wyświetlenie komunikatu błędu dotyczącego wynagrodzenia zasadniczego.
                MessageBox.Show("Nieprawidłowa wielkość wynagrodzenia zasadniczego."); 
            } 

            // Zwrot wyniku. 
            return inputGood; 
        }

        private void calculateButton_Click(object sender, EventArgs e)
        {
            // Zmienne przechowujące wynagrodzenie zasadnicze, premię i kwotę przekazywaną na konto emerytalne. 
            decimal grossPay = 0m, bonus = 0m, contributions = 0m;
            
            if (InputIsValid(ref grossPay, ref bonus))
            {
                // Obliczenie kwoty przekazywanej na konto emerytalne. 
                contributions = (grossPay + bonus) * CONTRIB_RATE;
                
                // Wyświetlenie obliczonej kwoty. 
                contributionLabel.Text = contributions.ToString("c");
             }
        }

        private void exitButton_Click(object sender, EventArgs e)
        {
            // Zamknięcie formularza. 
            this.Close();
        }
    }
}
